//
//  AppDelegate.m
//  AdDemo
//
//  Created by Liubin on 2024/6/28.
//

#import "AppDelegate.h"
#import "ViewController.h"
#import <HLAds/HMAdsSDKExtension.h>

#import <AppTrackingTransparency/AppTrackingTransparency.h>
#import <AdSupport/AdSupport.h>

#define HM_APPID @"80035"


@interface AppDelegate ()<HMAdsSplashAdDelegate>

@property (nonatomic, strong) ViewController *viewController;

@property (nonatomic, strong) HMAdsSplashAd *splash;


@end

@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    // Override point for customization after application launch.
    
    if (self.window == nil) {
        UIWindow *keyWindow = [[UIWindow alloc] initWithFrame:[UIScreen mainScreen].bounds];
        [keyWindow makeKeyAndVisible];
        self.window = keyWindow;
        self.window.rootViewController = [self rootViewController];
    }
    
    return YES;
}

- (void)requestIDFA {
    if (@available(iOS 14, *)) {
        [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
        }];
    }
}

- (void)applicationDidBecomeActive:(UIApplication *)application {
   // 申请权限代码 requestAppTrackAuth ;
//    [self requestIDFA];
    
}


- (UIViewController *)rootViewController {
    ViewController *mainViewController = [[ViewController alloc] init];
    UINavigationController *navigationVC = [[UINavigationController alloc] initWithRootViewController:mainViewController];
    return navigationVC;
}

- (void)loadSplashAd{
    self.splash = [[HMAdsSplashAd alloc] initHMAdsSplashAdWithPlacementId:@"8003501" adSize:[UIScreen mainScreen].bounds.size];
    self.splash.splashWindow = self.window;
    self.splash.delegate = self;
    self.splash.launchImageName = @"testImage";
    [self.splash loadAdData];
}

#pragma mark - 开屏Delegate
/**
 * 开屏广告开始请求
 */
- (void)splashHMAdsDidStartAd:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏开始请求");
}

/**
 * 开屏广告加载成功
 */
- (void)splashHMAdsDidReceiveAd:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏加载成功");
}

/**
 * 开屏广告展示成功
 */
- (void)splashHMAdsDidShowAd:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏展示成功");
}

/**
 开屏广告接收失败回调
 */
- (void)splashHMAds:(HMAdsSplashAd *)splashAd didFailWithError:(NSError *)error {
    NSLog(@"开屏失败回调：%@",error);
}

/**
 * 开屏点击广告回调
 */
- (void)splashHMAdsClickAd:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏点击");
}

/**
 * 开屏关闭广告回调
 */
- (void)splashHMAdsClosedAd:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏关闭");
}

/**
 * 开屏关闭Web回调
 */
- (void)splashHMAdDidClosedWebBrower:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏落地页关闭");
}


@end
