//
//  ViewController.m
//  AdDemo
//
//  Created by Liubin on 2024/6/28.
//

#import "ViewController.h"
#import <SafariServices/SafariServices.h>
#import <HLAds/HMAdsSDKExtension.h>

#import "HLNativeTableViewController.h"


@interface ViewController ()
<
    HMAdsSplashAdDelegate,
    HMAdsFeedAdDelegate,
    HMAdsBannerAdDelegate,
    HMAdsInterstitialAdDelegate,
    HMAdsRewardVideoAdDelegate
>


@property (nonatomic, strong) HMAdsSplashAd *splash;
@property (nonatomic, strong) HMAdsInterstitialAd *interstital;
@property (nonatomic, strong) HMAdsBannerAd *banner;
@property (nonatomic, strong) HMAdsFeedAd *feed;
@property (nonatomic, strong) HMAdsRewardVideoAd *rewardVideo;

@property (nonatomic, assign) BOOL loadFeedSuccess;
@property (nonatomic, strong) UIView * feedView;

@property (nonatomic, assign) BOOL loadBannerSuccess;
@property (nonatomic, strong) UIView * bannerView;

@property (nonatomic, assign) BOOL loadInterSuccess;
@property (nonatomic, assign) BOOL loadRewardVideoSuccess;
@property (nonatomic, assign) BOOL loadSplashSuccess;

@property (nonatomic, strong) UIView *bgView;

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self showButton];

}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    BOOL isAgree = [[NSUserDefaults standardUserDefaults] boolForKey:@"agreeUnlinkAd"];
     if (isAgree) {
         self.bgView.hidden = NO;
     } else {
         dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.3 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
             [self presentAlert];
         });
     }
}

- (void)showButton {
    UIView *view = [[UIView alloc] initWithFrame:self.view.bounds];
    [self.view addSubview:view];
    self.bgView = view;
    self.bgView.hidden = YES;
    
    UIButton *initBtn = [UIButton buttonWithType:UIButtonTypeSystem];
    initBtn.frame = CGRectMake(50, 120, 100, 30);
    [initBtn setTitle:@"初始化" forState:UIControlStateNormal];
    [initBtn addTarget:self action:@selector(initULinkSDK) forControlEvents:UIControlEventTouchUpInside];
    [self.bgView addSubview:initBtn];

    UIButton *configBtn = [UIButton buttonWithType:UIButtonTypeSystem];
    configBtn.frame = CGRectMake(200, 120, 100, 30);
    [configBtn setTitle:@"请求广告配置" forState:UIControlStateNormal];
    [configBtn addTarget:self action:@selector(loadAdsSDK) forControlEvents:UIControlEventTouchUpInside];
    [self.bgView addSubview:configBtn];
    
    
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeSystem];
    btn.frame = CGRectMake(50, 180, 100, 30);
    [btn setTitle:@"加载原生" forState:UIControlStateNormal];
    [btn addTarget:self action:@selector(loadFeedAd) forControlEvents:UIControlEventTouchUpInside];
    [self.bgView addSubview:btn];
    
    UIButton *showFeedBtn = [UIButton buttonWithType:UIButtonTypeSystem];
    showFeedBtn.frame = CGRectMake(200, 180, 100, 30);
    [showFeedBtn setTitle:@"展示原生" forState:UIControlStateNormal];
    [showFeedBtn addTarget:self action:@selector(showFeedAd) forControlEvents:UIControlEventTouchUpInside];
    [self.bgView addSubview:showFeedBtn];
    
    UIButton *interbtn = [UIButton buttonWithType:UIButtonTypeSystem];
    interbtn.frame = CGRectMake(50, 240, 100, 30);
    [interbtn setTitle:@"加载插屏" forState:UIControlStateNormal];
    [interbtn addTarget:self action:@selector(loadInterstitiaAd) forControlEvents:UIControlEventTouchUpInside];
    [self.bgView addSubview:interbtn];

    UIButton *showInterBtn = [UIButton buttonWithType:UIButtonTypeSystem];
    showInterBtn.frame = CGRectMake(200, 240, 100, 30);
    [showInterBtn setTitle:@"展示插屏" forState:UIControlStateNormal];
    [showInterBtn addTarget:self action:@selector(showInterAd) forControlEvents:UIControlEventTouchUpInside];
    [self.bgView addSubview:showInterBtn];

    UIButton *splashbtn = [UIButton buttonWithType:UIButtonTypeSystem];
    splashbtn.frame = CGRectMake(50, 300, 100, 30);
    [splashbtn setTitle:@"加载开屏" forState:UIControlStateNormal];
    [splashbtn addTarget:self action:@selector(loadSplashAd) forControlEvents:UIControlEventTouchUpInside];
    [self.bgView addSubview:splashbtn];
    
    UIButton *showSplashBtn = [UIButton buttonWithType:UIButtonTypeSystem];
    showSplashBtn.frame = CGRectMake(200, 300, 100, 30);
    [showSplashBtn setTitle:@"展示开屏" forState:UIControlStateNormal];
    [showSplashBtn addTarget:self action:@selector(showSplashAd) forControlEvents:UIControlEventTouchUpInside];
    [self.bgView addSubview:showSplashBtn];

    
//    UIButton *bannerbtn = [UIButton buttonWithType:UIButtonTypeSystem];
//    bannerbtn.frame = CGRectMake(50, 460, 100, 30);
//    [bannerbtn setTitle:@"Banner广告" forState:UIControlStateNormal];
//    [bannerbtn addTarget:self action:@selector(loadBannerAd) forControlEvents:UIControlEventTouchUpInside];
//    [self.bgView addSubview:bannerbtn];
//
//    UIButton *showBannerBtn = [UIButton buttonWithType:UIButtonTypeSystem];
//    showBannerBtn.frame = CGRectMake(200, 460, 100, 30);
//    [showBannerBtn setTitle:@"展示Banner" forState:UIControlStateNormal];
//    [showBannerBtn addTarget:self action:@selector(showBannerAd) forControlEvents:UIControlEventTouchUpInside];
//    [self.bgView addSubview:showBannerBtn];
    
//    UIButton *rewardBtn = [UIButton buttonWithType:UIButtonTypeSystem];
//    rewardBtn.frame = CGRectMake(50, 400, 100, 30);
//    [rewardBtn setTitle:@"激励视频广告" forState:UIControlStateNormal];
//    [rewardBtn addTarget:self action:@selector(loadRewardAd) forControlEvents:UIControlEventTouchUpInside];
//    [self.bgView addSubview:rewardBtn];
//
//    UIButton *showRewardBtn = [UIButton buttonWithType:UIButtonTypeSystem];
//    showRewardBtn.frame = CGRectMake(200, 400, 100, 30);
//    [showRewardBtn setTitle:@"展示激励视频" forState:UIControlStateNormal];
//    [showRewardBtn addTarget:self action:@selector(showRewardAd) forControlEvents:UIControlEventTouchUpInside];
//    [self.bgView addSubview:showRewardBtn];
    
    
//    UIButton *listNativeBtn = [UIButton buttonWithType:UIButtonTypeSystem];
//    listNativeBtn.frame = CGRectMake(20, 560, 150, 30);
//    [listNativeBtn setTitle:@"模板原生列表Demo" forState:UIControlStateNormal];
//    [listNativeBtn addTarget:self action:@selector(loadListFeedAdDemo) forControlEvents:UIControlEventTouchUpInside];
//    [self.bgView addSubview:listNativeBtn];
}


#pragma mark - 跳转模板信息流广告列表demo
- (void)loadListFeedAdDemo{
    HLNativeTableViewController *vc = [[HLNativeTableViewController alloc] init];
    vc.modalPresentationStyle = UIModalPresentationFullScreen;
    [self presentViewController:vc animated:YES completion:^{
        
    }];
}

#pragma mark - 初始化
- (void)initULinkSDK {
    // 初始化SDK
    [HMAdsSDK initWithAppId:@"80035"];
    // 是否打开日志，默认关闭
    [HMAdsSDK setLogLevel:HMAdsSDKLogDebug];
}

#pragma mark - 请求广告配置
- (void)loadAdsSDK {
    __weak typeof(self) weakSelf = self;
    [HMAdsSDK startWithCompletionHandler:^(BOOL success, NSError * _Nonnull error) {
        NSLog(@"广告配置加载结果：%d, \n\n错误信息：%@", success, error);
        NSString *title = @"";
        if (success) {
            title = @"广告配置加载成功";
        } else {
            title = @"广告配置加载失败";
        }
        [weakSelf showAlertWithTitle:title Handler:^(UIAlertAction *action) {
            
        }];
    }];
}


#pragma mark - 加载信息流
- (void)loadFeedAd {
    self.feed = [[HMAdsFeedAd alloc] initHMAdsFeedAdWithPlacementId:@"8003503" adSize:CGSizeZero];
    self.feed.rootViewController = self;
    self.feed.delegate = self;
//    [self.feed loadFeedImgaeStyle:HLAdsFeedImageStyleFull edge:0];
    [self.feed loadAdData];
}

- (void)showFeedAd {
    if (!self.loadFeedSuccess) {
        [self showAlertWithTitle:@"信息流等待加载" Handler:^(UIAlertAction *action) {
            
        }];
        return;
    }
    
    [self.view addSubview:self.feedView];
    CGRect frame = self.feedView.frame;
    frame.origin.x = self.view.frame.size.width/2-frame.size.width/2;
    frame.origin.y = 300;
    self.feedView.frame = frame;
}

#pragma mark - 加载开屏
- (void)loadSplashAd {
    self.splash = [[HMAdsSplashAd alloc] initHMAdsSplashAdWithPlacementId:@"8003501" adSize:CGSizeMake(self.view.frame.size.width, self.view.frame.size.height)];
    self.splash.splashWindow = self.view.window;
    self.splash.delegate = self;
//    self.splash.launchImageName = @"Your LaunchImage";
    [self.splash loadAdData];
}

- (void)showSplashAd {
    if (!self.loadSplashSuccess) {
        [self showAlertWithTitle:@"开屏等待加载" Handler:^(UIAlertAction *action) {
            
        }];
        return;
    }
    [self.splash showSplashAd];
}

#pragma mark - 加载插屏
- (void)loadInterstitiaAd {
    self.interstital = [[HMAdsInterstitialAd alloc] initHMAdsInterstitialPlacementId:@"8003502" adWithAdSize:CGSizeMake(320, 480)];
    self.interstital.delegate = self;
    [self.interstital loadAdData];
}

- (void)showInterAd {
    if (!self.loadInterSuccess) {
        [self showAlertWithTitle:@"插屏等待加载" Handler:^(UIAlertAction *action) {
            
        }];
        return;
    }
    [self.interstital showInterstitialAdWithViewController:self];
}

#pragma mark - 加载Banner
- (void)loadBannerAd {
    self.banner = [[HMAdsBannerAd alloc] initHMAdsBannerAdWithPlacementId:@"8003504" adSize:CGSizeMake(0, 0)];
    self.banner.rootViewController = self;
    self.banner.delegate = self;
    [self.banner loadAdData];
}

- (void)showBannerAd {
    if (!self.loadBannerSuccess) {
        [self showAlertWithTitle:@"banner等待加载" Handler:^(UIAlertAction *action) {
            
        }];
        return;
    }
    [self.view addSubview:self.bannerView];
    CGRect frame = self.bannerView.frame;
    frame.origin.x = self.view.frame.size.width/2-frame.size.width/2;
    frame.origin.y = 600;
    self.bannerView.frame = frame;
}

#pragma mark - 加载激励视频
- (void)loadRewardAd {
    self.rewardVideo = [[HMAdsRewardVideoAd alloc] initHMAdsRewardVideoPlacementId:@"8003504"];
    self.rewardVideo.delegate = self;
    [self.rewardVideo loadAdData];
}

- (void)showRewardAd {
    if (!self.loadRewardVideoSuccess) {
        [self showAlertWithTitle:@"激励视频等待加载" Handler:^(UIAlertAction *action) {
            
        }];
        return;
    }
    [self.rewardVideo showRewardVideoAdWithViewController:self];
}

#pragma mark - Feed Delegate
/**
 * feed广告开始请求
 */
- (void)feedAdHMAdsDidStartAd:(HMAdsFeedAd *)feedAd {
    NSLog(@"信息流开始请求:%@", feedAd);
}

/**
 * feed广告加载成功
 */
- (void)feedAdHMAds:(HMAdsFeedAd *)feedAd didReceiveAd:(UIView *)feedView {
    NSLog(@"信息流加载成功：%@ 单价：%.f",feedView, [self.feed adEcpm]);
    self.loadFeedSuccess = YES;
    if(self.feedView) {
        [self.feedView removeFromSuperview];
        self.feedView = nil;
    }
    self.feedView = feedView;
    [self showAlertWithTitle:@"信息流加载成功" Handler:^(UIAlertAction *action) {
        
    }];
}

- (void)feedAdHMAds:(HMAdsFeedAd *)feedAd didRenderSuccessAd:(UIView *)feedView {
    NSLog(@"信息流渲染成功：%@",feedView);
}

/**
 * feed广告展示成功
 */
- (void)feedAdHMAdsDidShowAd:(HMAdsFeedAd *)feedAd view:(UIView *)view {
    NSLog(@"信息流展示:%@",view);
    self.loadFeedSuccess = NO;
}

/**
   feed广告接收失败回调
 */
- (void)feedAdHMAds:(HMAdsFeedAd *)feedAd didFailWithError:(NSError *)error {
    NSLog(@"信息流失败:%@",error);
    self.loadFeedSuccess = NO;
    NSString *str = [NSString stringWithFormat:@"信息流加载失败：%@",error.localizedDescription];
    [self showAlertWithTitle:str Handler:^(UIAlertAction *action) {
        
    }];
}

/**
 * feed点击广告回调
 */
- (void)feedAdHMAdsClickAd:(HMAdsFeedAd *)feedAd view:(UIView *)view {
    NSLog(@"信息流点击:%@",view);
}

/**
 * feed关闭广告回调
 */
- (void)feedAdHMAdsClosedAd:(HMAdsFeedAd *)feedAd view:(UIView *)view {
    NSLog(@"信息流关闭:%@",view);
}

- (void)feedAdHMAdDidClosedWebBrower:(HMAdsFeedAd *)feedAd {
    NSLog(@"信息流落地页关闭:%@", feedAd);
}

#pragma mark - 开屏Delegate
/**
 * 开屏广告开始请求
 */
- (void)splashHMAdsDidStartAd:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏开始请求：%@", splashAd);
}

/**
 * 开屏广告加载成功
 */
- (void)splashHMAdsDidReceiveAd:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏加载成功：%@ 单价：%.f", splashAd, [self.splash adEcpm]);
    self.loadSplashSuccess = YES;
    [self showAlertWithTitle:@"开屏加载成功" Handler:^(UIAlertAction *action) {

    }];
}

/**
 * 开屏广告展示成功
 */
- (void)splashHMAdsDidShowAd:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏展示成功：%@", splashAd);
}

/**
 开屏广告接收失败回调
 */
- (void)splashHMAds:(HMAdsSplashAd *)splashAd didFailWithError:(NSError *)error {
    NSLog(@"开屏失败回调 %@ \nerror：%@", splashAd, error);
    NSString *str = [NSString stringWithFormat:@"开屏加载失败：%@",error.localizedDescription];
    [self showAlertWithTitle:str Handler:^(UIAlertAction *action) {
        
    }];
}

/**
 * 开屏点击广告回调
 */
- (void)splashHMAdsClickAd:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏点击：%@", splashAd);
}

/**
 * 开屏关闭广告回调
 */
- (void)splashHMAdsClosedAd:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏关闭：%@", splashAd);
}

- (void)splashHMAdDidClosedWebBrower:(HMAdsSplashAd *)splashAd {
    NSLog(@"开屏落地页关闭：%@", splashAd);
}


#pragma mark - 插屏Delegate

/**
 * 插屏广告开始请求
 */
- (void)interstitialHMAdsDidStartAd:(HMAdsInterstitialAd *)interstitialAd {
    NSLog(@"插屏开始请求：%@", interstitialAd);
}

/**
 * 插屏广告加载成功
 */
- (void)interstitialHMAdsDidReceiveAd:(HMAdsInterstitialAd *)interstitialAd {
    NSLog(@"插屏加载成功：%@ 单价：%.f", interstitialAd, [self.interstital adEcpm]);
    self.loadInterSuccess = YES;
    [self showAlertWithTitle:@"插屏加载成功" Handler:^(UIAlertAction *action) {

    }];
}

/**
 * 插屏广告展示成功
 */
- (void)interstitialHMAdsDidShowAd:(HMAdsInterstitialAd *)interstitialAd {
    NSLog(@"插屏展示成功：%@", interstitialAd);
    self.loadInterSuccess = NO;

}

/**
 插屏广告接收失败回调
 */
- (void)interstitialHMAds:(HMAdsInterstitialAd *)interstitialAd didFailWithError:(NSError *)error {
    NSLog(@"插屏加载失败：%@ \nerror：%@", interstitialAd, error);
    self.loadInterSuccess = NO;
    NSString *str = [NSString stringWithFormat:@"插屏加载失败：%@",error.localizedDescription];
    [self showAlertWithTitle:str Handler:^(UIAlertAction *action) {

    }];

}

/**
 * 插屏点击广告回调
 */
- (void)interstitialHMAdsClickAd:(HMAdsInterstitialAd *)interstitialAd {
    NSLog(@"插屏点击：%@", interstitialAd);
}

/**
 * 插屏关闭广告回调
 */
- (void)interstitialHMAdsClosedAd:(HMAdsInterstitialAd *)interstitialAd {
    NSLog(@"插屏关闭：%@", interstitialAd);
}

- (void)interstitialHMAdDidClosedWebBrower:(nonnull HMAdsInterstitialAd *)interstitialAd {
    NSLog(@"插屏落地页关闭：%@", interstitialAd);
}


#pragma mark - 横幅Delegate
/**
 * banner广告开始请求
 */
- (void)bannerHMAdsDidStartAd:(HMAdsBannerAd *)bannerAd {
    NSLog(@"横幅开始请求：%@", bannerAd);
}

/**
 * banner广告加载成功
 */
- (void)bannerHMAds:(HMAdsBannerAd *)bannerAd didReceiveAd:(UIView *)view {
    NSLog(@"横幅加载成功：%@ \n单价：%.f", bannerAd, [self.banner adEcpm]);
    self.loadBannerSuccess = YES;
    if(self.bannerView) {
        [self.bannerView removeFromSuperview];
        self.bannerView = nil;
    }
    self.bannerView = view;
    [self showBannerAd];
}

/**
 * banner广告展示成功
 */
- (void)bannerHMAdsDidShowAd:(HMAdsBannerAd *)bannerAd view:(nonnull UIView *)view {
    NSLog(@"横幅展示成功:%@ \n视图：%@", bannerAd, view);
    self.loadBannerSuccess = YES;
}

/**
 banner广告接收失败回调
 */
- (void)bannerHMAds:(HMAdsBannerAd *)bannerAd didFailWithError:(NSError *)error {
    NSLog(@"横幅失败：%@ \n error:%@", bannerAd, error);
    self.loadBannerSuccess = NO;
    NSString *str = [NSString stringWithFormat:@"Banner加载失败：%@",error.localizedDescription];
    [self showAlertWithTitle:str Handler:^(UIAlertAction *action) {
        
    }];
    
}

/**
 * banner点击广告回调
 */
- (void)bannerHMAdsClickAd:(HMAdsBannerAd *)bannerAd view:(nonnull UIView *)view {
    NSLog(@"横幅点击:%@", bannerAd);
}


/**
 * banner关闭广告回调
 */
- (void)bannerHMAdsClosedAd:(HMAdsBannerAd *)bannerAd {
    NSLog(@"横幅关闭:%@", bannerAd);
    // 如果关闭时不再需要轮播展示，需要将self.banner置为nil
    self.banner = nil;
}

- (void)bannerHMAdDidClosedWebBrower:(nonnull HMAdsBannerAd *)bannerAd {
    NSLog(@"横幅落地页关闭:%@", bannerAd);
}


#pragma mark -- 激励视频Delegate
/**
 * 激励式视频广告开始请求
 */
- (void)rewardVideoHMAdsDidStartAd:(HMAdsRewardVideoAd *)rewardVideoAd {
    NSLog(@"激励视频请求成功");
}

/**
 * 激励式视频广告加载成功
 */
- (void)rewardVideoHMAdsDidReceiveAd:(HMAdsRewardVideoAd *)rewardVideoAd {
    NSLog(@"激励视频加载成功：%@ 单价：%.f", rewardVideoAd, [self.rewardVideo adEcpm]);
    self.loadRewardVideoSuccess = YES;
    [self showAlertWithTitle:@"激励视频加载成功" Handler:^(UIAlertAction *action) {
        
    }];
}

/**
 * 激励式视频广告展示成功
 */
- (void)rewardVideoHMAdsDidShowAd:(HMAdsRewardVideoAd *)rewardVideoAd {
    NSLog(@"激励视频展示成功");
    self.loadRewardVideoSuccess = NO;
}

/**
 * 激励式视频广告达到激励条件回调，以此回调作为奖励依据
 */
- (void)rewardVideoHMAdsDidRewardEffective:(HMAdsRewardVideoAd *)rewardVideoAd {
    NSLog(@"激励视频获取奖励");
}

/**
 * 激励式视频广告播放完成回调
 */
- (void)rewardVideoHMAdsDidPlayFinish:(HMAdsRewardVideoAd *)rewardVideoAd {
    NSLog(@"激励视频播放完成");
}

/**
 * 激励式视频广告接收失败回调
 */
- (void)rewardVideoHMAds:(HMAdsRewardVideoAd *)rewardVideoAd didFailWithError:(NSError *)error {
    NSLog(@"激励视频加载失败：%@", error);
    self.loadRewardVideoSuccess = NO;
    NSString *str = [NSString stringWithFormat:@"激励视频加载失败：%@",error.localizedDescription];
    [self showAlertWithTitle:str Handler:^(UIAlertAction *action) {
        
    }];
}

/**
 * 激励式视频点击广告回调
 */
- (void)rewardVideoHMAdsClickAd:(HMAdsRewardVideoAd *)rewardVideoAd {
    NSLog(@"激励视频点击");
}

/**
 * 激励式视频关闭广告回调
 */
- (void)rewardVideoHMAdsClosedAd:(HMAdsRewardVideoAd *)rewardVideoAd {
    NSLog(@"激励视频关闭");
}




- (void)showAlertWithTitle:(NSString *)title Handler:(void (^ __nullable)(UIAlertAction *action))handler {
    UIAlertController *alter = [UIAlertController alertControllerWithTitle:nil message:title preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *sure = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        handler(action);
    }];
    [alter addAction:sure];
    UIWindow * window = [[UIApplication sharedApplication].delegate window];
    [window.rootViewController presentViewController:alter animated:YES completion:nil];
}



- (void)presentAlert {
    // 1. 定义标题文本（用于后续匹配查找）
    NSString *titleText = @"使用ULinkSDK Demo之前，请您阅读并知悉我们的《隐私政策》。 如果您选择开始使用我们的应用，请点击“同意”";
    
    // 2. 创建Alert（标题先用空字符串占位）
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@""
                                                                   message:@""
                                                            preferredStyle:UIAlertControllerStyleAlert];
    
    // 3. 设置富文本标题
    NSMutableAttributedString *attributedTitle = [[NSMutableAttributedString alloc] initWithString:titleText];
    [attributedTitle addAttribute:NSForegroundColorAttributeName value:[UIColor blackColor] range:NSMakeRange(0, titleText.length)];
    [attributedTitle addAttribute:NSUnderlineStyleAttributeName value:@(NSUnderlineStyleSingle) range:[titleText rangeOfString:@"《隐私政策》"]];
    [alert setValue:attributedTitle forKey:@"attributedTitle"];
    
    // 4. 关键修复：延迟查找标题Label（确保视图层级加载完成）
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.2 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        // 通过文本内容匹配查找标题Label（替代tag查找，适配所有iOS版本）
        UILabel *titleLabel = [self findTitleLabelInView:alert.view targetText:titleText];
        if (titleLabel) {
            NSLog(@"找到标题Label：%@", titleLabel);
            titleLabel.userInteractionEnabled = YES; // 必须开启交互
            // 添加手势（使用强引用避免手势被释放）
            UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(alertTitleDidTap)];
            [titleLabel addGestureRecognizer:tap];
        } else {
            NSLog(@"未找到标题Label，请检查视图层级");
        }
    });
        
    UIAlertAction *cancel = [UIAlertAction actionWithTitle:@"拒绝" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull action) {
        exit(0);
    }];
    [alert addAction:cancel];
    UIAlertAction *sure = [UIAlertAction actionWithTitle:@"同意" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"agreeUnlinkAd"];
        self.bgView.hidden = NO;
    }];
    [alert addAction:sure];
    [self presentViewController:alert animated:YES completion:nil];
}


#pragma mark - 查找标题Label（通过文本内容匹配）
- (UILabel *)findTitleLabelInView:(UIView *)superView targetText:(NSString *)text {
    for (UIView *subView in superView.subviews) {
        if ([subView isKindOfClass:[UILabel class]]) {
            UILabel *label = (UILabel *)subView;
            // 匹配文本内容（包括富文本）
            if ([label.text isEqualToString:text] ||
                [label.attributedText.string isEqualToString:text]) {
                return label;
            }
        }
        // 递归查找子视图
        UILabel *foundLabel = [self findTitleLabelInView:subView targetText:text];
        if (foundLabel) return foundLabel;
    }
    return nil;
}

- (void)alertTitleDidTap {
    // 1. 先关闭 Alert（避免与网页控制器叠加）
    [self dismissViewControllerAnimated:YES completion:^{
        // 2. 目标网页 URL（替换为你需要打开的链接，支持 HTTP/HTTPS）
        NSURL *targetURL = [NSURL URLWithString:@"https://dev.ulinkad.com/manager/Policy.html"];
        //  初始化系统网页控制器（SFSafariViewController）
        SFSafariViewController *safariVC = [[SFSafariViewController alloc] initWithURL:targetURL];
        // 弹出系统网页控制器（模态弹出，与 Safari 体验一致）
        [self presentViewController:safariVC animated:YES completion:nil];
    }];
}


@end
