//
//  HMAdsAdNetworkAdapter.h
//  TestFrameWork
//
//  Created by Liubin on 15/04/18.
//  Copyright © 2018年 LiuBin. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

#import "HMAdsNetworkRegistry.h"
#import "HMAdsSplashNetWorkRegistry.h"
#import "HMAdsBannerNetWorkRegistry.h"
#import "HMAdsFeedNetworkRegistry.h"
#import "HMAdsInterstitialNetworkRegistry.h"
#import "HMAdsRewardVideoNetworkRegistry.h"

#import "HMAdsSplashAd.h"
#import "HMAdsInterstitialAd.h"
#import "HMAdsBannerAd.h"
#import "HMAdsFeedAd.h"
#import "HMAdsRewardVideoAd.h"


extern NSString *HMAdsHLAdapter;
extern NSString *HMAdsGDTAdapter;
extern NSString *HMAdsCSJAdapter;
extern NSString *HMAdsKSAdapter;
extern NSString *HMAdsBaiDuAdapter;


@class HMAdsSourceModel, HMAdsCoreRowNode;

@interface HMAdsAdNetworkAdapter : NSObject

@property (nonatomic, copy, readonly) NSString * adAppId;

@property (nonatomic, copy, readonly) NSString * adSlotId;

/// 广告数据对象
@property (nonatomic, strong) HMAdsSourceModel * provider;

/// 广告数据处理
@property (nonatomic, strong) HMAdsCoreRowNode * rowNode;



/// 开屏广告
- (id)initWithSplashAdsHMAdapterDelegate:(id<HMAdsSplashAdDelegate>)delegate
                                    view:(HMAdsSplashAd *)view
                                    core:(id)core
                                provider:(HMAdsSourceModel *)provider
                                  adType:(NSUInteger)adType;

/// 插屏广告
- (id)initWithInterstitialAdsHMAdapterDelegate:(id<HMAdsInterstitialAdDelegate>)delegate
                                    view:(HMAdsInterstitialAd *)view
                                    core:(id)core
                                      provider:(HMAdsSourceModel *)provider
                                  adType:(NSUInteger)adType;

/// 横幅广告
- (id)initWithBannerAdsHMAdapterDelegate:(id<HMAdsBannerAdDelegate>)delegate
                                    view:(HMAdsBannerAd *)view
                                    core:(id)core
                                provider:(HMAdsSourceModel *)provider
                                  adType:(NSUInteger)adType;

/// Feed广告
- (id)initWithFeedAdsHMAdapterDelegate:(id<HMAdsFeedAdDelegate>)delegate
                                    view:(HMAdsFeedAd *)view
                                    core:(id)core
                              provider:(HMAdsSourceModel *)provider
                                  adType:(NSUInteger)adType;

/// 激励视频广告
- (id)initWithRewardVideoAdsHMAdapterDelegate:(id<HMAdsRewardVideoAdDelegate>)delegate
                                         view:(HMAdsRewardVideoAd *)view
                                         core:(id)core
                                     provider:(HMAdsSourceModel *)provider
                                       adType:(NSUInteger)adType;

/// 竞价价格
- (void)setBidEcpm:(CGFloat)ecpm;

/// 手动预设置信息流广告图片位置，【仅适用部分平台，不是限制所有平台广告样式】
- (void)loadFeedImgaeStyle:(HLAdsFeedImageStyle)style edge:(CGFloat)edge;
    

#pragma mark - 子类Adapter触发广告节点
/// 获取处理事件的控制器
- (UIViewController *)adapterViewControllerForShowAds;


/// 获取配置的window
- (UIWindow *)adapterWindowForShowAdsView;

/// 配置广告的宽高
- (CGSize)adapterViewSizeForShowAds;

/// 广告开始请求
- (void)adapterAdStartRequest:(HMAdsAdNetworkAdapter *)adapter;

/// 广告请求成功
- (void)adapterAdDidReceive:(HMAdsAdNetworkAdapter *)adapter view:(UIView *)view adPrice:(CGFloat)adPrice;

/// 广告渲染成功
- (void)adapterAdDidRenderSuccess:(HMAdsAdNetworkAdapter *)adapter view:(UIView *)view;

/// 广告展示
- (void)adapterAdShow:(HMAdsAdNetworkAdapter *)adapter view:(UIView *)view;

/// 广告点击
- (void)adapterAdClick:(HMAdsAdNetworkAdapter *)adapter view:(UIView *)view;

/// 广告将要关闭
- (void)adapterAdWillClose:(HMAdsAdNetworkAdapter *)adapter view:(UIView *)view;

/// 广告关闭
- (void)adapterAdClosed:(HMAdsAdNetworkAdapter *)adapter view:(UIView *)view;

/// 广告加载失败
- (void)adapterAd:(HMAdsAdNetworkAdapter *)adapter didFailedAd:(NSError *)error;

/// 广告打开落地页
- (void)adapterAdDidStartWebBrower:(HMAdsAdNetworkAdapter *)adapter;

/// 广告关闭落地页
- (void)adapterAdDidClosedWebBrower:(HMAdsAdNetworkAdapter *)adapter;

/// 广告打开App deeplink
- (void)adapterAdDidOpenApp:(HMAdsAdNetworkAdapter *)adapter;


/// 激励视频广告播放完毕
- (void)adapterAdDidPlayFinish:(HMAdsAdNetworkAdapter *)adapter view:(UIView *)view;

/// 激励视频广告获取奖励
- (void)adapterAdDidRewardEffective:(HMAdsAdNetworkAdapter *)adapter;


@end
