//
//  HMAdsRewardVideoAd.h
//  HMAdsSDK
//
//  Created by Liubin on 2021/5/7.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class HMAdsRewardVideoAd;
@protocol HMAdsRewardVideoAdDelegate<NSObject>

/**
 * 激励式视频广告开始请求
 */
- (void)rewardVideoHMAdsDidStartAd:(HMAdsRewardVideoAd *)rewardVideoAd;

/**
 * 激励式视频广告加载成功
 */
- (void)rewardVideoHMAdsDidReceiveAd:(HMAdsRewardVideoAd *)rewardVideoAd;

/**
 * 激励式视频广告展示成功
 */
- (void)rewardVideoHMAdsDidShowAd:(HMAdsRewardVideoAd *)rewardVideoAd;

/**
 * 激励式视频广告达到激励条件回调，以此回调作为奖励依据
 */
- (void)rewardVideoHMAdsDidRewardEffective:(HMAdsRewardVideoAd *)rewardVideoAd;

/**
 * 激励式视频广告播放完成回调
 */
- (void)rewardVideoHMAdsDidPlayFinish:(HMAdsRewardVideoAd *)rewardVideoAd;

/**
 * 激励式视频广告接收失败回调
 */
- (void)rewardVideoHMAds:(HMAdsRewardVideoAd *)rewardVideoAd didFailWithError:(NSError *)error;

/**
 * 激励式视频点击广告回调
 */
- (void)rewardVideoHMAdsClickAd:(HMAdsRewardVideoAd *)rewardVideoAd;

/**
 * 激励式视频关闭广告回调
 */
- (void)rewardVideoHMAdsClosedAd:(HMAdsRewardVideoAd *)rewardVideoAd;


@end


@interface HMAdsRewardVideoAd : NSObject


@property (nonatomic, weak) id <HMAdsRewardVideoAdDelegate> delegate;

/// 初始化激励视频广告
/// - Parameter placementId: 广告位id
- (instancetype)initHMAdsRewardVideoPlacementId:(NSString *)placementId;

/// 加载激励式视频广告
- (void)loadAdData;

/// 展示激励式视频广告
- (void)showRewardVideoAdWithViewController:(UIViewController *)viewController;

/// 返回广告的eCPM，单位：分
- (CGFloat)adEcpm;


@end

NS_ASSUME_NONNULL_END
