//
//  HMAdsBannerAd.h
//  HMAdsSDK
//
//  Created by Liubin on 2020/12/26.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class HMAdsBannerAd;
@protocol HMAdsBannerAdDelegate <NSObject>

/**
 * banner广告开始请求
 */
- (void)bannerHMAdsDidStartAd:(HMAdsBannerAd *)bannerAd;

/**
 * banner广告加载成功
 */
- (void)bannerHMAds:(HMAdsBannerAd *)bannerAd didReceiveAd:(UIView *)view;

/**
 * banner广告展示成功
 */
- (void)bannerHMAdsDidShowAd:(HMAdsBannerAd *)bannerAd view:(UIView *)view;

/**
 banner广告接收失败回调
 */
- (void)bannerHMAds:(HMAdsBannerAd *)bannerAd didFailWithError:(NSError *)error;

/**
 * banner点击广告回调
 */
- (void)bannerHMAdsClickAd:(HMAdsBannerAd *)bannerAd view:(UIView *)view;

/**
 * banner关闭广告回调
 * 会立即关闭当前banner广告，若启用轮播，（刷新间隔 - 当前广告已展示时间）后会展示新的广告
 * 若未启用轮播或不需要再展示，需在回调中将您使用的HMAdsBannerAd对象置nil，注：不是将当前回调中的bannerAd置nil
 */
- (void)bannerHMAdsClosedAd:(HMAdsBannerAd *)bannerAd;
/**
 * banner关闭落地页回调
 */
- (void)bannerHMAdDidClosedWebBrower:(HMAdsBannerAd *)bannerAd;

@end



@interface HMAdsBannerAd : NSObject

@property (nonatomic, weak) id <HMAdsBannerAdDelegate> delegate;

/// 处理事件，弹出落地页的控制器
@property (nonatomic, weak) UIViewController *rootViewController;


/// 初始化开屏
/// - Parameters:
///   - placementId: 广告位id
///   - adSize: 广告尺寸
- (instancetype)initHMAdsBannerAdWithPlacementId:(NSString *)placementId adSize:(CGSize)adSize;

/// 加载banner广告
- (void)loadAdData;

/// 返回广告的eCPM，单位：分
- (CGFloat)adEcpm;


@end

NS_ASSUME_NONNULL_END
