//
//  HMAdsinterstitialAd.h
//  HMAdsSDK
//
//  Created by Liubin on 2020/12/26.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class HMAdsInterstitialAd;
@protocol HMAdsInterstitialAdDelegate <NSObject>

/**
 * 插屏广告开始请求
 */
- (void)interstitialHMAdsDidStartAd:(HMAdsInterstitialAd *)interstitialAd;

/**
 * 插屏广告加载成功
 */
- (void)interstitialHMAdsDidReceiveAd:(HMAdsInterstitialAd *)interstitialAd;

/**
 * 插屏广告展示成功
 */
- (void)interstitialHMAdsDidShowAd:(HMAdsInterstitialAd *)interstitialAd;

/**
 插屏广告接收失败回调
 */
- (void)interstitialHMAds:(HMAdsInterstitialAd *)interstitialAd didFailWithError:(NSError *)error;

/**
 * 插屏点击广告回调
 */
- (void)interstitialHMAdsClickAd:(HMAdsInterstitialAd *)interstitialAd;

/**
 * 插屏关闭广告回调
 */
- (void)interstitialHMAdsClosedAd:(HMAdsInterstitialAd *)interstitialAd;

/**
 * 插屏关闭落地页回调
 */
- (void)interstitialHMAdDidClosedWebBrower:(HMAdsInterstitialAd *)interstitialAd;

@end


@interface HMAdsInterstitialAd : NSObject


@property (nonatomic, weak) id <HMAdsInterstitialAdDelegate> delegate;

/// 启动图名称
@property (nonatomic, strong) NSString *launchImageName;


/// 初始化信息流广告
/// - Parameters:
///   - placementId: 广告位id
///   - adSize: 广告尺寸
- (instancetype)initHMAdsInterstitialPlacementId:(NSString *)placementId adWithAdSize:(CGSize)adSize;

/// 加载插屏广告
- (void)loadAdData;

/// 展示插屏广告
- (void)showInterstitialAdWithViewController:(UIViewController *)viewController;

/// 返回广告的eCPM，单位：分
- (CGFloat)adEcpm;

@end

NS_ASSUME_NONNULL_END
