//
//  HMAdsNetworkRegistry.h
//  TestFrameWork
//
//  Created by Liubin on 15/04/18.
//  Copyright © 2018年 LiuBin. All rights reserved.
//
//

#import <Foundation/Foundation.h>

@class HMAdsClassWrapper;
@class HMAdsAdNetworkAdapter;


@interface HMAdsNetworkRegistry : NSObject
{
    //记录所有注册平台ID的字典
    NSMutableDictionary * _adapterDict;
}

+ (HMAdsNetworkRegistry*)sharedRegistry;



/**
 注册adapter

 @param adapterClass 平台adapter类
 */
- (void)registerClass:(Class)adapterClass;



/**
 获取所有已注册平台ID

 @return 记录平台ID的字典
 */
- (NSMutableDictionary *)getAdapterDict;



/**
 根据平台的ID获取registry对象

 @param adNetworkType 平台ID
 @return registry对象
 */
- (HMAdsClassWrapper*)adapterClassFor:(NSString*)adNetworkType;




@end
