//
//  HMAdsSplashAd.h
//  HMAdsSDK
//
//  Created by Liubin on 2020/12/26.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class HMAdsSplashAd;
@protocol HMAdsSplashAdDelegate <NSObject>

/**
 * 开屏广告开始请求
 */
- (void)splashHMAdsDidStartAd:(HMAdsSplashAd *)splashAd;

/**
 * 开屏广告加载成功
 */
- (void)splashHMAdsDidReceiveAd:(HMAdsSplashAd *)splashAd;

/**
 * 开屏广告展示成功
 */
- (void)splashHMAdsDidShowAd:(HMAdsSplashAd *)splashAd;


/**
 开屏广告接收失败回调
 */
- (void)splashHMAds:(HMAdsSplashAd *)splashAd didFailWithError:(NSError *)error;

/**
 * 开屏点击广告回调
 */
- (void)splashHMAdsClickAd:(HMAdsSplashAd *)splashAd;

/**
 * 开屏关闭广告回调
 */
- (void)splashHMAdsClosedAd:(HMAdsSplashAd *)splashAd;

/**
 * 开屏关闭落地页回调
 */
- (void)splashHMAdDidClosedWebBrower:(HMAdsSplashAd *)splashAd;


@end


@interface HMAdsSplashAd : NSObject

@property (nonatomic, weak) id <HMAdsSplashAdDelegate> delegate;

/// 展示开屏的window，且存在rootViewController
@property (nonatomic, weak) UIWindow *splashWindow;

/// 启动图名称（加载时全屏铺满）
@property (nonatomic, strong) NSString *launchImageName;


/// 初始化开屏
/// - Parameters:
///   - placementId: 广告位id
///   - adSize: 广告位尺寸
- (instancetype)initHMAdsSplashAdWithPlacementId:(NSString *)placementId adSize:(CGSize)adSize;

/// 加载开屏广告
- (void)loadAdData;

/// 展示开屏
- (void)showSplashAd;

/// 返回广告的eCPM，单位：分
- (CGFloat)adEcpm;

@end

NS_ASSUME_NONNULL_END
