//
//  HMAdsFeedAd.h
//  HMAdsSDK
//
//  Created by Liubin on 2021/1/10.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN


typedef NS_ENUM(NSInteger, HLAdsFeedImageStyle) {
    /** 大图*/
    HLAdsFeedImageStyleFull ,
    /** 左文右图*/
    HLAdsFeedImageStyleRight,
    /** 左图右文*/
    HLAdsFeedImageStyleLeft,
    /** 上图下文*/
    HLAdsFeedImageStyleTop,

};

@class HMAdsFeedAd;


@protocol HMAdsFeedAdDelegate <NSObject>
/**
 * feed广告开始请求
 */
- (void)feedAdHMAdsDidStartAd:(HMAdsFeedAd *)feedAd;

/**
 * feed广告加载成功
 */
- (void)feedAdHMAds:(HMAdsFeedAd *)feedAd didReceiveAd:(UIView *)feedView;

/**
 * feed广告渲染成功
 */
- (void)feedAdHMAds:(HMAdsFeedAd *)feedAd didRenderSuccessAd:(UIView *)feedView;

/**
 * feed广告展示成功
 */
- (void)feedAdHMAdsDidShowAd:(HMAdsFeedAd *)feedAd view:(UIView *)view;

/**
   feed广告接收失败回调
 */
- (void)feedAdHMAds:(HMAdsFeedAd *)feedAd didFailWithError:(NSError *)error;

/**
 * feed点击广告回调
 */
- (void)feedAdHMAdsClickAd:(HMAdsFeedAd *)feedAd view:(UIView *)view;

/**
 * feed关闭广告回调
 */
- (void)feedAdHMAdsClosedAd:(HMAdsFeedAd *)feedAd view:(UIView *)view;

/**
 * feed关闭落地页回调
 */
- (void)feedAdHMAdDidClosedWebBrower:(HMAdsFeedAd *)feedAd;

@end


@interface HMAdsFeedAd : NSObject

@property (nonatomic, weak) id <HMAdsFeedAdDelegate> delegate;

/// 处理事件，弹出落地页的控制器
@property (nonatomic, weak) UIViewController *rootViewController;


/// 初始化信息流广告
/// - Parameters:
///   - placementId: 广告位id
///   - adSize: 广告尺寸，自适应布局可以设置CGSizeZero
- (instancetype)initHMAdsFeedAdWithPlacementId:(NSString *)placementId adSize:(CGSize)adSize;

/// 加载信息流广告
- (void)loadAdData;

/// 返回广告的eCPM，单位：分
- (CGFloat)adEcpm;


/// 手动预设置广告图片位置，【注：执行loadAdData之前使用；仅适用部分平台，并不是限制所有平台广告样式】
/// - Parameters:
///   - style: 广告样式，详情查看枚举
///   - edge: 上下左右间隙
- (void)loadFeedImgaeStyle:(HLAdsFeedImageStyle)style edge:(CGFloat)edge;


@end

NS_ASSUME_NONNULL_END
