//
//  HMAdsSDK.h
//  HMAdsSDK
//
//  Created by Liubin on 2021/3/22.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, HMAdsSDKLogLevel) {
    /** 关闭Log */
    HMAdsSDKLogNone,
    /** Debug Log */
    HMAdsSDKLogDebug
};


@interface HMAdsSDK : NSObject


/**
 * 初始化  SDK
 * @param appId 广告应用标识
*/
+ (void)initWithAppId:(NSString *)appId;

/**
 * 启动  SDK
 * @param handler 启动成功/失败的结果回调
 * @note 请先调用initWithAppId接口后，尽快调用startWithCompletionHandler接口;
*/
+ (void)startWithCompletionHandler:(void(^)(BOOL success, NSError *error))handler;

/**
 * 获取当前SDK Version 版本号
 */
+ (NSString *)sdkVersion;

/// 设置log
/// @param level 枚举值
+ (void)setLogLevel:(HMAdsSDKLogLevel)level;


@end

NS_ASSUME_NONNULL_END
